//############################################################################//
//             Copyright (c) 2006, by Deluxe-Menu.com
//             Deluxe Tuner script
//             http://deluxe-menu.com
//             Programming by Shakhmatov Nik
//             E-mail: cs@deluxe-menu.com
//############################################################################//


function dm_getFileName(fpath)
{
    var fname='';
    for (var i=fpath.length-1; i>=0 && fpath.charAt(i)!='\/'; i--) fname = fpath.charAt(i) + fname;
    return fname;
}


function dm_getItemData(filesPath, itemLvl, pText, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10)
{
  function cp(v)
  {
      return ((typeof(v)!='undefined' && v!=null) ? '"'+v+'", ':', ');
  }

  function setFilePth(fname)
  {
      if (filesPath=='.') return dm_getFileName(fname);
      else                return (filesPath && fname ? filesPath + dm_getFileName(fname) : fname);
  }

  //----------------------------------------------------------
  var specChars='';;
  var lvlStr='', lvlSpace='    ';

  if (pText!='' && pText.charAt(0)=='$')
  {
      specChars += pText.charAt(0);
      pText = pText.substr(1, pText.length-1);
  }

  for (var i=0; i<itemLvl; i++)
  {
      lvlStr += '|';
      lvlSpace += '    ';
  }

  var data = lvlSpace + '[';
  data += '"' + specChars + lvlStr + pText + '",';
  data += '"'+(p1?p1:'')+'", '+cp(setFilePth(p2))+cp(setFilePth(p3))+cp(p4)+cp(p5)+cp(p6)+cp(p7)+cp(p8);//+cp(p9)+cp(p10);
  data += ']';
  return data;
}


function dm_addOption(selObj, val, txt)
{
  var opt = document.createElement('OPTION');
  opt.value = val;
  opt.text  = txt;
  if (b_IE)
      selObj.add(opt);
  else
      selObj.add(opt, null);
}


function dm_setIndividualStyles(stylesType, stylesStr)       // used by Tuner
// Sets individual styles for specified style type (item styles, menu styles)
{
  var selObj = document.getElementById((stylesType==0)?'itemStyle_id':'submenuStyle_id');
  if (!selObj) return false;

  curSelInd = selObj.selectedIndex;

  while (selObj.options.length>0) selObj.remove(0);


  if (typeof(stylesStr)=='string')            // stylesStr is a string with styles name when the function is called from Windows Tuner
  {
      var stylesArr = stylesStr.split(String.fromCharCode(13));
      for (var i=0; i<stylesArr.length; i++) dm_addOption(selObj, i, stylesArr[i])
  }
  else                                        // stylesStr is an array of styles name when the function is called from HTML Tuner
      for (var i=0; i<stylesStr.length; i++) dm_addOption(selObj, i, stylesStr[i][0])

  selObj.selectedIndex = curSelInd;
}


function dm_changeItemParam(paramInd)
// Requests item parameter value from Tuner
{
  if (setFromTuner) return;

  if (dmDeluxeTuner)
      window.status='@'+paramInd+':null';
  else
      parent.frames[2].window.setChangedItemParam(parseInt(paramInd.substr(4, paramInd.length)));
}

